package edu.unika.aifb.kaon.api.oimodel;

import java.util.Set;
import java.util.Map;

import edu.unika.aifb.kaon.api.*;

/**
 * Represents a lexcical entry about a model element.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface LexicalEntry extends Instance {
    /**
     * Retruns the set of URI determining the type of this entry.
     *
     * @return                      URI determining the type of this entry
     */
    String getTypeURI() throws KAONException;
    /**
     * Returns all named entities referenced by this instance.
     *
     * @return                      set of named entities referenced by this entry
     */
    Set getReferencedEntities() throws KAONException;
    /**
     * Returns the map of attribute values indexed by appropriate URIs. Elements are either <code>String</code> or <code>Instance</code> objects.
     *
     * @return                      map of attribute values
     */
    Map getAttributeValues() throws KAONException;
    /**
     * Returns the value of attribute of this object. Return value may be either a <code>String</code> or an <code>Instance</code> object.
     *
     * @param attributeURI          URI of the attribute
     * @return                      value of the attribute with given URI (may be a <code>String</code>, <code>Instance</code> of <code>null</code>)
     */
    Object getAttribute(String attributeURI) throws KAONException;
    /**
     * Returns the language attribute of this lexical entry.
     *
     * @return                      language of this lexical entry
     */
    String getInLanguage() throws KAONException;
    /**
     * Returns the value attribute of this lexical entry.
     *
     * @return                      value of this lexical entry
     */
    String getValue() throws KAONException;
}
