package edu.unika.aifb.kaon.api.oimodel;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;

/**
 * Represents a container for all instances.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface InstancePool {
    /**
     * Returns an instance with given URI.
     *
     * @param uri                       URI of the requested instnace
     * @return                          instance with given URI
     */
    Instance getInstance(String uri) throws KAONException;
    /**
     * Returns all instances of this ontology.
     *
     * @return                          set of all instances in this ontology
     */
    Set getInstances() throws KAONException;
    /**
     * Returns a lexical entry with given URI.
     *
     * @param uri                       URI of the requested lexical entry
     * @return                          lexical entry with given URI
     */
    LexicalEntry getLexicalEntry(String uri) throws KAONException;
    /**
     * Factory method for property instance objects.
     *
     * @param property                  property
     * @param sourceInstance            source instance
     * @param targetValue               target value (<code>Instance</code> or a <code>String</code>)
     */
    PropertyInstance getPropertyInstance(Property property,Instance sourceInstance,Object targetValue) throws KAONException;
}