package edu.unika.aifb.kaon.api.oimodel;

import edu.unika.aifb.kaon.api.*;

/**
 * Visitor interface for entities.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface EntityVisitor {
    /**
     * Visits a concpet.
     */
    void visit(Concept entity) throws KAONException;
    /**
     * Visits a property.
     */
    void visit(Property entity) throws KAONException;
    /**
     * Visits an instance.
     */
    void visit(Instance entity) throws KAONException;
    /**
     * Visits a lexical entry.
     */
    void visit(LexicalEntry entity) throws KAONException;
}
