package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Sets a symmetry flag for a property.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class SetPropertySymmetric extends ChangeEvent {
    /** Property for which cardinality is set. */
    protected Property m_property;
    /** New symmetry value. */
    protected boolean m_symmetric;
    /** Old symmetry value. */
    protected boolean m_oldSymmetric;

    /**
     * Creates a request to set the symmetry flag for a property.
     *
     * @param property                  property
     * @param symmetric                 symmetry value
     */
    public SetPropertySymmetric(Property property,boolean symmetric) {
        this(null,null,property,symmetric);
    }
    /**
     * Creates a request to set the symmetry flag for a property.
     *
     * @param cause                     the cause event
     * @param property                  property
     * @param symmetric                 symmetry value
     */
    public SetPropertySymmetric(ChangeEvent cause,Property property,boolean symmetric) {
        this(null,cause,property,symmetric);
    }
    /**
     * Creates a request to set the symmetry flag for a property.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param property                  property
     * @param symmetric                 symmetry value
     */
    public SetPropertySymmetric(OIModel oimodel,ChangeEvent cause,Property property,boolean symmetric) {
        super(oimodel,cause);
        m_property=property;
        m_symmetric=symmetric;
    }
    /**
     * Returns the property.
     *
     * @return                          property
     */
    public Property getProperty() {
        return m_property;
    }
    /**
     * Returns the symmetry flag.
     *
     * @return                          symmetry flag
     */
    public boolean getSymmetric() {
        return m_symmetric;
    }
    /**
     * Returns the old symmetry flag.
     *
     * @return                          old symmetry flag
     */
    public boolean getOldSymmetric() {
        return m_oldSymmetric;
    }
    /**
     * Sets the old symmetry flag.
     *
     * @param oldSymmetric              old symmetry flag
     */
    public void setOldSymmetric(boolean oldSymmetric) {
        m_oldSymmetric=oldSymmetric;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof SetPropertySymmetric))
            return false;
        SetPropertySymmetric thatEvent=(SetPropertySymmetric)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_property,thatEvent.m_property))
            return false;
        if (m_symmetric!=thatEvent.m_symmetric)
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return (hashCode(m_oimodel)*7+hashCode(m_property))*7+hashCode(m_symmetric);
    }
}
