package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Makes the property to be an attribute.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class SetPropertyIsAttribute extends ChangeEvent {
    /** Property for which attribute flag is set. */
    protected Property m_property;
    /** New attribute value. */
    protected boolean m_isAttribute;
    /** Old attribute value. */
    protected boolean m_oldIsAttribute;

    /**
     * Creates a request to set the attribute flag for the property.
     *
     * @param property                  property
     * @param isAttribute               determines whether property is an attribute
     */
    public SetPropertyIsAttribute(Property property,boolean isAttribute) {
        this(null,null,property,isAttribute);
    }
    /**
     * Creates a request to set the attribute flag for the property.
     *
     * @param cause                     the cause event
     * @param property                  property
     * @param isAttribute               determines whether property is an attribute
     */
    public SetPropertyIsAttribute(ChangeEvent cause,Property property,boolean isAttribute) {
        this(null,cause,property,isAttribute);
    }
    /**
     * Creates a request to set the attribute flag for the property.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param property                  property
     * @param isAttribute               determines whether property is an attribute
     */
    public SetPropertyIsAttribute(OIModel oimodel,ChangeEvent cause,Property property,boolean isAttribute) {
        super(oimodel,cause);
        m_property=property;
        m_isAttribute=isAttribute;
    }
    /**
     * Returns the property.
     *
     * @return                          property
     */
    public Property getProperty() {
        return m_property;
    }
    /**
     * Returns the transitivity flag.
     *
     * @return                          attribute flag
     */
    public boolean getIsAttribute() {
        return m_isAttribute;
    }
    /**
     * Returns the old attribute flag.
     *
     * @return                          old attribute flag
     */
    public boolean getOldIsAttribute() {
        return m_oldIsAttribute;
    }
    /**
     * Sets the old attribute flag.
     *
     * @param oldIsAttribute            old attribute flag
     */
    public void setOldIsAttirubte(boolean oldIsAttribute) {
        m_oldIsAttribute=oldIsAttribute;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof SetPropertyIsAttribute))
            return false;
        SetPropertyIsAttribute thatEvent=(SetPropertyIsAttribute)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_property,thatEvent.m_property))
            return false;
        if (m_isAttribute!=thatEvent.m_isAttribute)
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return (hashCode(m_oimodel)*7+hashCode(m_property))*7+hashCode(m_isAttribute);
    }
}
