package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Establishes the inverse connection between two properties.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class SetInverseProperties extends ChangeEvent {
    /** First property. */
    protected Property m_property1;
    /** Second property. */
    protected Property m_property2;

    /**
     * Creates a request to associate two properties with an inverse relationship.
     *
     * @param property1                 first property
     * @param property2                 second property
     */
    public SetInverseProperties(Property property1,Property property2) {
        this(null,null,property1,property2);
    }
    /**
     * Creates a request to associate two properties with an inverse relationship.
     *
     * @param cause                     the cause event
     * @param property1                 first property
     * @param property2                 second property
     */
    public SetInverseProperties(ChangeEvent cause,Property property1,Property property2) {
        this(null,cause,property1,property2);
    }
    /**
     * Creates a request to associate two properties with an inverse relationship.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param property1                 first property
     * @param property2                 second property
     */
    public SetInverseProperties(OIModel oimodel,ChangeEvent cause,Property property1,Property property2) {
        super(oimodel,cause);
        m_property1=property1;
        m_property2=property2;
    }
    /**
     * Returns the first property.
     *
     * @return                          first property
     */
    public Property getProperty1() {
        return m_property1;
    }
    /**
     * Returns the second property.
     *
     * @return                          second property
     */
    public Property getProperty2() {
        return m_property2;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof SetInverseProperties))
            return false;
        SetInverseProperties thatEvent=(SetInverseProperties)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_property1,thatEvent.m_property1))
            return false;
        if (!equals(m_property2,thatEvent.m_property2))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return (hashCode(m_oimodel)*7+hashCode(m_property1))*7+hashCode(m_property2);
    }
}
