package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Removes a property instance.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class RemovePropertyInstance extends ChangeEvent {
    /** Property instance to remove. */
    protected PropertyInstance m_propertyInstance;

    /**
     * Removes a property instance for an instance.
     *
     * @param property                  property
     * @param sourceInstance            source instance
     * @param targetValue               target value
     * @throws KAONException            thrown if there is an error
     */
    public RemovePropertyInstance(Property property,Instance sourceInstance,Object targetValue) throws KAONException {
        this(null,null,property,sourceInstance,targetValue);
    }
    /**
     * Removes a property instance..
     *
     * @param propertyInstance          property instance to remove
     */
    public RemovePropertyInstance(PropertyInstance propertyInstance) {
        this((OIModel)null,null,propertyInstance);
    }
    /**
     * Removes a property instance for an instance.
     *
     * @param cause                     the cause event
     * @param property                  property
     * @param sourceInstance            source instance
     * @param targetValue               target value
     * @throws KAONException            thrown if there is an error
     */
    public RemovePropertyInstance(ChangeEvent cause,Property property,Instance sourceInstance,Object targetValue) throws KAONException {
        this(null,cause,property,sourceInstance,targetValue);
    }
    /**
     * Removes a property instance..
     *
     * @param cause                     the cause event
     * @param propertyInstance          property instance to remove
     */
    public RemovePropertyInstance(ChangeEvent cause,PropertyInstance propertyInstance) {
        this(null,cause,propertyInstance);
    }
    /**
     * Removes a property instance for an instance.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param property                  property
     * @param sourceInstance            source instance
     * @param targetValue               target value
     * @throws KAONException            thrown if there is an error
     */
    public RemovePropertyInstance(OIModel oimodel,ChangeEvent cause,Property property,Instance sourceInstance,Object targetValue) throws KAONException {
        this(oimodel,cause,property.getOIModel().getPropertyInstance(property,sourceInstance,targetValue));
    }
    /**
     * Removes a property instance..
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param propertyInstance          property instance to remove
     */
    public RemovePropertyInstance(OIModel oimodel,ChangeEvent cause,PropertyInstance propertyInstance) {
        super(oimodel,cause);
        m_propertyInstance=propertyInstance;
    }
    /**
     * Returns the property instance being added.
     *
     * @return                          property instance
     */
    public PropertyInstance getPropertyInstance() {
        return m_propertyInstance;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof RemovePropertyInstance))
            return false;
        RemovePropertyInstance thatEvent=(RemovePropertyInstance)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_propertyInstance,thatEvent.m_propertyInstance))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return hashCode(m_oimodel)*7+hashCode(m_propertyInstance);
    }
}
