package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Makes an instance not a subinstance of given concept.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class RemoveInstanceOf extends ChangeEvent {
    /** Concept. */
    protected Concept m_concept;
    /** Instance. */
    protected Instance m_instance;

    /**
     * Makes an instance not a subinstnace of given concept.
     *
     * @param concept                   concept
     * @param instance                  instance
     */
    public RemoveInstanceOf(Concept concept,Instance instance) {
        this(null,null,concept,instance);
    }
    /**
     * Makes an instance not a subinstnace of given concept.
     *
     * @param cause                     the cause event
     * @param concept                   concept
     * @param instance                  instance
     */
    public RemoveInstanceOf(ChangeEvent cause,Concept concept,Instance instance) {
        this(null,cause,concept,instance);
    }
    /**
     * Makes an instance not a subinstnace of given concept.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param concept                   concept
     * @param instance                  instance
     */
    public RemoveInstanceOf(OIModel oimodel,ChangeEvent cause,Concept concept,Instance instance) {
        super(oimodel,cause);
        m_concept=concept;
        m_instance=instance;
    }
    /**
     * Returns the concept.
     *
     * @return                          concept
     */
    public Concept getConcept() {
        return m_concept;
    }
    /**
     * Returns the instnace.
     *
     * @return                          instance
     */
    public Instance getInstance() {
        return m_instance;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof RemoveInstanceOf))
            return false;
        RemoveInstanceOf thatEvent=(RemoveInstanceOf)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_concept,thatEvent.m_concept))
            return false;
        if (!equals(m_instance,thatEvent.m_instance))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return (hashCode(m_oimodel)*7+hashCode(m_concept))*7+hashCode(m_instance);
    }
}
