package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Makes one OI-model not included in another OI-model.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class RemoveIncludedOIModel extends ChangeEvent {
    /** Included OI-model. */
    protected OIModel m_includedOIModel;

    /**
     * Creates a request to make an OI-model not included in another OI-model.
     *
     * @param includedOIModel           OI-model that is included in another OI-model
     */
    public RemoveIncludedOIModel(OIModel includedOIModel) {
        this(null,null,includedOIModel);
    }
    /**
     * Creates a request to make an OI-model not included in another OI-model.
     *
     * @param cause                     the cause event
     * @param includedOIModel           OI-model that is included in another OI-model
     */
    public RemoveIncludedOIModel(ChangeEvent cause,OIModel includedOIModel) {
        this(null,cause,includedOIModel);
    }
    /**
     * Creates a request to make an OI-model not included in another OI-model.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param includedOIModel           OI-model that is included in another OI-model
     */
    public RemoveIncludedOIModel(OIModel oimodel,ChangeEvent cause,OIModel includedOIModel) {
        super(oimodel,cause);
        m_includedOIModel=includedOIModel;
    }
    /**
     * Returns the included OI-model.
     *
     * @return                          included OI-model
     */
    public OIModel getIncludedOIModel() {
        return m_includedOIModel;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof RemoveIncludedOIModel))
            return false;
        RemoveIncludedOIModel thatEvent=(RemoveIncludedOIModel)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_includedOIModel,thatEvent.m_includedOIModel))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return hashCode(m_oimodel)*7+hashCode(m_includedOIModel);
    }
}
