package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Change request for all removals from the entity pool.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class RemoveEntity extends ChangeEvent {
    /** Entity to be removed. */
    protected Entity m_entity;

    /**
     * Removes an entity from the ontology.
     *
     * @param entity                    entity to remove
     */
    public RemoveEntity(Entity entity) {
        this(null,null,entity);
    }
    /**
     * Removes an entity from the ontology.
     *
     * @param cause                     the cause event
     * @param entity                    entity to remove
     */
    public RemoveEntity(ChangeEvent cause,Entity entity) {
        this(null,cause,entity);
    }
    /**
     * Removes an entity from the ontology.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param entity                    entity to remove
     */
    public RemoveEntity(OIModel oimodel,ChangeEvent cause,Entity entity) {
        super(oimodel,cause);
        m_entity=entity;
    }
    /**
     * Returns the entity to remove.
     *
     * @return                          entity to remove
     */
    public Entity getEntity() {
        return m_entity;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof RemoveEntity))
            return false;
        RemoveEntity thatEvent=(RemoveEntity)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_entity,thatEvent.m_entity))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return hashCode(m_oimodel)*7+hashCode(m_entity);
    }
}
