package edu.unika.aifb.kaon.api.change;

import java.util.List;
import java.util.EventListener;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Listener interace for notifications about bulk of change events in the OI-model.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface OIModelListener extends EventListener {
    /**
     * Called when a bulk of change events is processed in the pool.
     *
     * @param oimodel                   OI-model that was changed
     * @param changeEvents              list of change events that occured
     */
    void modelChanged(OIModel oimodel,List changeEvents);
    /**
     * Called when model is refreshed.
     *
     * @param oimodel                   OI-model that was refreshed
     */
    void modelRefreshed(OIModel oimodel);
    /**
     * Called when model is being deleted.
     *
     * @param oimodel                   OI-model that is being deleted
     */
    void modelDeleted(OIModel oimodel);
}