package edu.unika.aifb.kaon.api.change;

import java.util.List;

import edu.unika.aifb.kaon.api.*;

/**
 * Strategy for handling evolution issues.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface EvolutionStrategy {
    /**
     * Computes the list of elementary changes from given list of requested changes.
     *
     * @param changeList                list of requested changes
     * @return                          list of needed changes
     * @exception KAONException         thrown if changes cannot be applied
     */
    List computeRequestedChanges(List changeList) throws KAONException;
}
