package edu.unika.aifb.kaon.api.change;

import java.util.List;

import edu.unika.aifb.kaon.api.*;

/**
 * Strategy for handling evolution issues for dependent ontologies.
 *
 * @author Ljiljana Stojanovic (Ljiljana.Stojanovic@fzi.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface DependentEvolutionStrategy {
    /**
     * Computes the changes needed to keep the connection in a consistent state.
     *
     * @param changes               the starting changes
     * @return                      the extended list of changes
     * @throws KAONException        thrown if there is an error
     */
    List computeRequestedChanges(List changes) throws KAONException;
}
