package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;

/**
 * Visitor interface for change events.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface ChangeVisitor {
    /**
     * Visits AddEntity change.
     */
    void visit(AddEntity event) throws KAONException;
    /**
     * Visits RemoveEntity change.
     */
    void visit(RemoveEntity event) throws KAONException;
    /**
     * Visits an event for creation of subconcepts.
     */
    void visit(AddSubConcept event) throws KAONException;
    /**
     * Visits an event for removal of subconcepts.
     */
    void visit(RemoveSubConcept event) throws KAONException;
    /**
     * Visits an event for adding a domain to the property.
     */
    void visit(AddPropertyDomain event) throws KAONException;
    /**
     * Visits an event for removing a domain from the property.
     */
    void visit(RemovePropertyDomain event) throws KAONException;
    /**
     * Visits an event for adding a range to the property.
     */
    void visit(AddPropertyRange event) throws KAONException;
    /**
     * Visits an event for removing a range from the property.
     */
    void visit(RemovePropertyRange event) throws KAONException;
    /**
     * Visits an event for determinig whether property is attirubte.
     */
    void visit(SetPropertyIsAttribute event) throws KAONException;
    /**
     * Visits an event for setting the minimum cardinality of a property for a concept.
     */
    void visit(SetMinimumCardinality event) throws KAONException;
    /**
     * Visits an event for setting the maximum cardinality of a property for a concept.
     */
    void visit(SetMaximumCardinality event) throws KAONException;
    /**
     * Visits an event for creation of subproperties.
     */
    void visit(AddSubProperty event) throws KAONException;
    /**
     * Visits an event for removal of subproperties.
     */
    void visit(RemoveSubProperty event) throws KAONException;
    /**
     * Visits an event for setting the inverse relationship between properties.
     */
    void visit(SetInverseProperties event) throws KAONException;
    /**
     * Visits an event for removing an inverse relationship between properties.
     */
    void visit(SetNoInverseProperties event) throws KAONException;
    /**
     * Visits an event for setting the symmetry flag of the property.
     */
    void visit(SetPropertySymmetric event) throws KAONException;
    /**
     * Visits an event for setting the transitivity flag of the property.
     */
    void visit(SetPropertyTransitive event) throws KAONException;
    /**
     * Visits an event for making an instance a subinstance of given concept.
     */
    void visit(AddInstanceOf event) throws KAONException;
    /**
     * Visits an event for making an instance not a subinstance of given concept.
     */
    void visit(RemoveInstanceOf event) throws KAONException;
    /**
     * Visits an event for adding a property instance.
     */
    void visit(AddPropertyInstance event) throws KAONException;
    /**
     * Visits an event for removing a property instance.
     */
    void visit(RemovePropertyInstance event) throws KAONException;
    /**
     * Visits an event for setting the value of a property instance.
     */
    void visit(SetPropertyInstanceValue event) throws KAONException;
    /**
     * Visits an event for changing the value of a property instance.
     */
    void visit(ChangePropertyInstanceValue event) throws KAONException;
    /**
     * Visits an event for making a model included in another model.
     */
    void visit(AddIncludedOIModel event) throws KAONException;
    /**
     * Visits an event for making a model not included in another model.
     */
    void visit(RemoveIncludedOIModel event) throws KAONException;
}
