package edu.unika.aifb.kaon.api.change;

import java.io.Serializable;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Base class for all change events. Each change event can specify an event that caused this
 * event to happen.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public abstract class ChangeEvent implements Serializable {
    /** The cause for this event. */
    protected ChangeEvent m_cause;
    /** The OI-model for which this event was created. */
    protected OIModel m_oimodel;

    /**
     * Creates a change event and initializes it with the cause.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the event that caused this event to happen
     */
    public ChangeEvent(OIModel oimodel,ChangeEvent cause) {
        m_oimodel=oimodel;
        m_cause=cause;
    }
    /**
     * Returns the OI-model at which this change should be performed.
     *
     * @return                          the OI-model for which this change should be performed
     */
    public OIModel getOIModel() {
        return m_oimodel;
    }
    /**
     * Sets the OI-model at which this change should be performed.
     *
     * @param oimodel                   the OI-model for which this change should be performed
     */
    public void setOIModel(OIModel oimodel) {
        m_oimodel=oimodel;
    }
    /**
     * Returns the cause event.
     *
     * @return                          the event that caused this event
     */
    public ChangeEvent getCause() {
        return m_cause;
    }
    /**
     * Sets the cause event.
     *
     * @param cause                     the event that caused this event
     */
    public void setCause(ChangeEvent cause) {
        m_cause=cause;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public abstract void accept(ChangeVisitor visitor) throws KAONException;
    /**
     * Tests whether two objects are equals, even if one or both of them are <code>null</code>.
     *
     * @param o1                        the first object
     * @param o2                        the second object
     * @return                          <code>true</code> if objects are equal, or if both are <code>null</code>
     */
    protected boolean equals(Object o1,Object o2) {
        return o1==null ? o2==null : o1.equals(o2);
    }
    /**
     * Returns the hash-code of an object, even if the object is <code>null</code>.
     *
     * @param o                         the object
     * @return                          the hash-code of the object
     */
    protected int hashCode(Object o) {
        return o==null ? 0 : o.hashCode();
    }
    /**
     * Returns the hash-code of an booelan object.
     *
     * @param o                         the booelan object
     * @return                          the hash-code of the object
     */
    protected int hashCode(boolean o) {
        return o==true ? 1 : 0;
    }
}
