package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Adds a property as a subproperty in the pool.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class AddSubProperty extends ChangeEvent {
    /** Sueprproperty. */
    protected Property m_superProperty;
    /** Subproperty. */
    protected Property m_subProperty;

    /**
     * Creates an event to add a property as a subproperty of another property.
     *
     * @param superProperty             superproperty
     * @param subProperty               subproperty
     */
    public AddSubProperty(Property superProperty,Property subProperty) {
        this(null,null,superProperty,subProperty);
    }
    /**
     * Creates an event to add a property as a subproperty of another property.
     *
     * @param cause                     the cause event
     * @param superProperty             superproperty
     * @param subProperty               subproperty
     */
    public AddSubProperty(ChangeEvent cause,Property superProperty,Property subProperty) {
        this(null,cause,superProperty,subProperty);
    }
    /**
     * Creates an event to add a property as a subproperty of another property.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param superProperty             superproperty
     * @param subProperty               subproperty
     */
    public AddSubProperty(OIModel oimodel,ChangeEvent cause,Property superProperty,Property subProperty) {
        super(oimodel,cause);
        m_superProperty=superProperty;
        m_subProperty=subProperty;
    }
    /**
     * Returns the superproperty.
     *
     * @return                          superproperty
     */
    public Property getSuperProperty() {
        return m_superProperty;
    }
    /**
     * Returns the subproperty.
     *
     * @return                          subproperty
     */
    public Property getSubProperty() {
        return m_subProperty;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof AddSubProperty))
            return false;
        AddSubProperty thatEvent=(AddSubProperty)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_superProperty,thatEvent.m_superProperty))
            return false;
        if (!equals(m_subProperty,thatEvent.m_subProperty))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return (hashCode(m_oimodel)*7+hashCode(m_superProperty))*7+hashCode(m_subProperty);
    }
}
