package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Adds a concept as a subconcept in the pool.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class AddSubConcept extends ChangeEvent {
    /** Sueprconcept. */
    protected Concept m_superConcept;
    /** Subconcept. */
    protected Concept m_subConcept;

    /**
     * Makes a concept a subconcept of another concept.
     *
     * @param superConcept              superconcept
     * @param subConcept                subconcept
     */
    public AddSubConcept(Concept superConcept,Concept subConcept) {
        this(null,null,superConcept,subConcept);
    }
    /**
     * Makes a concept a subconcept of another concept.
     *
     * @param cause                     the cause event
     * @param superConcept              superconcept
     * @param subConcept                subconcept
     */
    public AddSubConcept(ChangeEvent cause,Concept superConcept,Concept subConcept) {
        this(null,cause,superConcept,subConcept);
    }
    /**
     * Makes a concept a subconcept of another concept.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the cause event
     * @param superConcept              superconcept
     * @param subConcept                subconcept
     */
    public AddSubConcept(OIModel oimodel,ChangeEvent cause,Concept superConcept,Concept subConcept) {
        super(oimodel,cause);
        m_superConcept=superConcept;
        m_subConcept=subConcept;
    }
    /**
     * Returns the superconcept.
     *
     * @return                          superconcept
     */
    public Concept getSuperConcept() {
        return m_superConcept;
    }
    /**
     * Returns the subconcept.
     *
     * @return                          subconcept
     */
    public Concept getSubConcept() {
        return m_subConcept;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof AddSubConcept))
            return false;
        AddSubConcept thatEvent=(AddSubConcept)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_superConcept,thatEvent.m_superConcept))
            return false;
        if (!equals(m_subConcept,thatEvent.m_subConcept))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return (hashCode(m_oimodel)*7+hashCode(m_superConcept))*7+hashCode(m_subConcept);
    }
}
