package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Adds a concept as a domain to a property.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class AddPropertyDomain extends ChangeEvent {
    /** Property for which domain is added. */
    protected Property m_property;
    /** Concept added. */
    protected Concept m_concept;

    /**
     * Creates a request to add a concept to the domain.
     *
     * @param property                  property
     * @param concept                   concept
     */
    public AddPropertyDomain(Property property,Concept concept) {
        this(null,null,property,concept);
    }
    /**
     * Creates a request to add a concept to the domain.
     *
     * @param cause                     the event that caused this event
     * @param property                  property
     * @param concept                   concept
     */
    public AddPropertyDomain(ChangeEvent cause,Property property,Concept concept) {
        this(null,cause,property,concept);
    }
    /**
     * Creates a request to add a concept to the domain.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the event that caused this event
     * @param property                  property
     * @param concept                   concept
     */
    public AddPropertyDomain(OIModel oimodel,ChangeEvent cause,Property property,Concept concept) {
        super(oimodel,cause);
        m_property=property;
        m_concept=concept;
    }
    /**
     * Returns the property.
     *
     * @return                          property
     */
    public Property getProperty() {
        return m_property;
    }
    /**
     * Returns the concept.
     *
     * @return                          concept
     */
    public Concept getConcept() {
        return m_concept;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof AddPropertyDomain))
            return false;
        AddPropertyDomain thatEvent=(AddPropertyDomain)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_property,thatEvent.m_property))
            return false;
        if (!equals(m_concept,thatEvent.m_concept))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return (hashCode(m_oimodel)*7+hashCode(m_property))*7+hashCode(m_concept);
    }
}
