package edu.unika.aifb.kaon.api.change;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Change request for all additions to the entity pool.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class AddEntity extends ChangeEvent {
    /** Entity to be added. */
    protected Entity m_entity;

    /**
     * Adds an entity to the ontology.
     *
     * @param entity                    entity to add
     */
    public AddEntity(Entity entity) {
        this(null,null,entity);
    }
    /**
     * Adds an entity to the ontology.
     *
     * @param cause                     the event that caused this event to happen
     * @param entity                    entity to add
     */
    public AddEntity(ChangeEvent cause,Entity entity) {
        this(null,cause,entity);
    }
    /**
     * Adds an entity to the ontology.
     *
     * @param oimodel                   the OI-model
     * @param cause                     the event that caused this event to happen
     * @param entity                    entity to add
     */
    public AddEntity(OIModel oimodel,ChangeEvent cause,Entity entity) {
        super(oimodel,cause);
        m_entity=entity;
    }
    /**
     * Returns the entity to add.
     *
     * @return                          entity to add
     */
    public Entity getEntity() {
        return m_entity;
    }
    /**
     * Accepts a visitor for this change request.
     *
     * @param visitor                   visitor of this change
     * @throws KAONException            thrown if there is an error
     */
    public void accept(ChangeVisitor visitor) throws KAONException {
        visitor.visit(this);
    }
    /**
     * Tests whether this object is equal to some other object.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof AddEntity))
            return false;
        AddEntity thatEvent=(AddEntity)that;
        if (!equals(m_oimodel,thatEvent.m_oimodel))
            return false;
        if (!equals(m_entity,thatEvent.m_entity))
            return false;
        return true;
    }
    /**
     * Returns the hash-code of an object.
     *
     * @return                          the hash-code of the object
     */
    public int hashCode() {
        return hashCode(m_oimodel)*7+hashCode(m_entity);
    }
}
