package edu.unika.aifb.kaon.api;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Exception thrown if it has been determined that OI-model contains data
 * that is stale. Usually this means that the data was changed on the server
 * by some other user.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class StaleDataException extends KAONException {
    /**
     * Creates an exception instance.
     */
    public StaleDataException() {
    }
    /**
     * Creates an exception instance.
     *
     * @param message           reason for failure
     */
    public StaleDataException(String message) {
        super(message);
    }
    /**
     * Creates an exception instance.
     *
     * @param cause             cause of this exception
     */
    public StaleDataException(Throwable cause) {
        super(cause);
    }
    /**
     * Creates an exception instance.
     *
     * @param message           reason for failure
     * @param cause             cause of this exception
     */
    public StaleDataException(String message,Throwable cause) {
        super(message,cause);
    }
    /**
     * Creates an exception instance.
     *
     * @param entity            entity that is stale
     */
    public StaleDataException(Entity entity) {
        super(getMessageText(entity));
    }
    /**
     * Returns the text of the message.
     *
     * @param entity            entity that is stale
     * @return                  message text
     */
    protected static String getMessageText(Entity entity) {
        try {
            return "This OI-model contains a stale version of the entity '"+entity.getURI()+"'.";
        }
        catch (KAONException e) {
            return "This OI-model contains a stale version of the entity.";
        }
    }
}
