package edu.unika.aifb.kaon.api;

import java.util.Map;

/**
 * Implemented by each KAON API implementation to resolve the physicalURI to the default parameters.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface PhysicalURIToDefaultParametersResolver {
    /**
     * Called by the KAONManager to attempt the resolution for given physical URI. If the resolution is successful,
     * non-null value should be returned.
     *
     * @param physicalURI           the physical URI
     * @param contextParameters     the parameters that are used for missing elements (may be <code>null</code>)
     * @return                      the default parameters for accessing the physical URI, or <code>null</code> if the parameters cannot be resolved
     */
    Map getDefaultParametersForPhysicalURI(String physicalURI,Map contextParameters);
}
