package edu.unika.aifb.kaon.api;

import java.util.Map;

/**
 * Resolves a logical URI to connection parameters and a physical URI.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public interface LogicalURIResolver {
    /**
     * Resolves a logical URI to the parameters and a physical URI. If this instance cannot do the resolution, <code>null</code>
     * is returned.
     *
     * @param logicalURI            the logical URI
     * @return                      the parameters and the physical URI for the logical URI
     */
    ResultHolder resolveLogicalURI(String logicalURI);

    /**
     * Holds the result if the resolution.
     */
    public static class ResultHolder {
        /** The connection parameters. */
        public Map m_connectionParameters;
        /** The physical URI. */
        public String m_physicalURI;
    }
}
