package edu.unika.aifb.kaon.api;

/**
 * Base exception for all exceptions thrown by the KAON API.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class KAONException extends Exception {
    /**
     * Creates an exception instance.
     */
    public KAONException() {
    }
    /**
     * Creates an exception instance.
     *
     * @param message           reason for failure
     */
    public KAONException(String message) {
        super(message);
    }
    /**
     * Creates an exception instance.
     *
     * @param cause             cause of this exception
     */
    public KAONException(Throwable cause) {
        super(cause);
    }
    /**
     * Creates an exception instance.
     *
     * @param message           reason for failure
     * @param cause             cause of this exception
     */
    public KAONException(String message,Throwable cause) {
        super(message,cause);
    }
}
