package edu.unika.aifb.kaon.api;

import java.util.Set;

/**
 * Exception for the distributed evolution.
 *
 * @author Ljiljana Stojanovic (Ljiljana.Stojanovic@fzi.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */

 public class DependentEvolutionKAONException extends KAONException {
    /* Set of oimodels that are out-of-date.*/
    protected Set m_oimodels;

    /**
     * Creates an exception instance.
     *
     * @param oimodels          OIModels that are out-of-date
     * @param message           reason for failure
     */
    public DependentEvolutionKAONException(Set oimodels,String message) {
        super(message);
        m_oimodels=oimodels;
    }
    /**
     * Creates an exception instance.
     *
     * @param oimodels          oimodels that are out-of-date
     * @param message           reason for failure
     * @param cause             cause of this exception
     */
    public DependentEvolutionKAONException(Set oimodels,String message,Throwable cause) {
        super(message,cause);
        m_oimodels=oimodels;
    }
    /**
     * Returns the set of OI-models that are cause of the exception.
     */
    public Set getOIModels() {
        return m_oimodels;
    }
}
