package de.fzi.wim.guibase.util;

import javax.swing.JLabel;
import javax.swing.AbstractButton;

/**
 * Utility class for handling mnemonics. Supports setting text to the controls that contains an ampersand before the characted
 * that should be used as mnemonic.
 */
public class Mnemonics {
    /**
     * Sets the text to the label and parses it to determine label's mnemonic. Mnemonic is designates as the character with an
     * ampersand before it.
     */
    public static void setText(JLabel label,String text) {
        label.setText(getLabelText(text));
        label.setDisplayedMnemonic(getLabelMnemonic(text));
    }
    /**
     * Sets the text to a button.
     */
    public static void setText(AbstractButton button,String text) {
        button.setText(getLabelText(text));
        button.setMnemonic(getLabelMnemonic(text));
    }
    /**
     * Returns the text that should be used as the text of the label. It will drop all &amp; characters and return only the text.
     *
     * @param text                  text that defines the label and mnemonic
     * @return                      text to be used as label
     */
    public static String getLabelText(String text) {
        if (text==null)
            return null;
        if (text.indexOf('~')==-1)
            return text;
        StringBuffer result=new StringBuffer();
        int length=text.length();
        for (int i=0;i<length;i++) {
            char current=text.charAt(i);
            if (current=='~' && i+1<length)
                current=text.charAt(++i);
            result.append(current);
        }
        return result.toString();
    }
    /**
     * Retruns the mnemonic of the label or -1 if label text doesn't specify mnemonic.
     *
     * @param text                  text that defines the label and mnemonic
     * @return                      mnemonic to be used (or -1)
     */
    public static int getLabelMnemonic(String text) {
        if (text==null)
            return 0;
        int length=text.length();
        for (int i=0;i<length;i++) {
            char current=text.charAt(i);
            if (current=='~' && i+1<length) {
                current=text.charAt(++i);
                if (current!='~')
                    return Character.toUpperCase(current);
            }
        }
        return -1;
    }
}