package de.fzi.wim.guibase.util;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/**
 * Extension of the file chooser that provides the default extension handling.
 */
public class JFileChooserEx extends JFileChooser {
    /**
     * Creates an instance of this class.
     */
    public JFileChooserEx() {
    }
    /**
     * Returns the selected file with the default extension attached to it.
     *
     * @return                      the selected file with the default extension added
     */
    public File getSelectedFileEx() {
        File selectedFile=getSelectedFile();
        if (selectedFile!=null) {
            FileFilter fileFilter=getFileFilter();
            if (fileFilter instanceof ExtensionFileFilter) {
                ExtensionFileFilter extensionFileFilter=(ExtensionFileFilter)fileFilter;
                selectedFile=extensionFileFilter.mangleFileName(selectedFile);
            }
        }
        return selectedFile;
    }
}
