package de.fzi.wim.guibase.treetable;

import javax.swing.tree.TreeModel;

/**
 * Model interface that can be used by {@link JTreeTable} objects.
 */
public interface TreeTableModel extends TreeModel {
    /**
     * Returns the number of columns in the model.
     *
     * @return                      number of columsn in the model
     */
    int getColumnCount();
    /**
     * Returns the name of the column with given index.
     *
     * @param column                index of column for which name is requested
     * @return                      name of column with given index
     */
    String getColumnName(int column);
    /**
     * Returns the class of the column with given index.
     *
     * @param column                index of column for which class is requested
     * @return                      class of column with given index
     */
    Class getColumnClass(int column);
    /**
     * Returns the value from an object at given column.
     *
     * @param node                  node whose value needs to be read
     * @param column                column whose value is requested
     * @return                      value of the column for given node
     */
    Object getValueAt(Object node,int column);
    /**
     * Checks whether cell for given node is editable.
     *
     * @param node                  node that needs to be tested
     * @param column                column that needs to be tested
     * @return                      <code>true</code> if the cell displaying the value is editable
     */
    boolean isCellEditable(Object node,int column);
    /**
     * Sets the value into a node at given column.
     *
     * @param aValue                value that needs to be set
     * @param node                  node whose value needs to be set
     * @param column                column whose value needs to be set
     */
    void setValueAt(Object aValue,Object node,int column);
}
