package de.fzi.wim.guibase.treetable;

/**
 * Instance implementing this interface is used by the {@link JTreeTable} to provide information about the size
 * of each path in the tree.
 *
 * @see JTreeTable
 */
public interface TreePathMeasurer {
    /**
     * Called to measure a path in the tree table.
     *
     * @param treeTable                     tree table where path is measured
     * @param node                          node being measured
     * @param row                           row in which path is measured
     * @param depth                         depth of the path being measured
     * @param size                          object to be filled with dimension information
     */
    void measureTreePath(JTreeTable treeTable,Object node,int row,int depth,TreePathDimensions size);

    /**
     * Holder class that receives information about path geometry.
     */
    public static class TreePathDimensions {
        /** Height of the path. */
        public int m_height;
        /** Number of pixels that a path must be indented. */
        public int m_indentation;
    }
}

