package de.fzi.wim.guibase.treetable;

import java.awt.Component;
import java.awt.Rectangle;

/**
 * Instance implementing this interface can be set into {@link JTreeTable} to render tree nodes. Instance of this class would
 * only render node information. Expand/collapse handles should not be painted by this instance. Most renderers will paint an
 * icon in front of every node - in that case, renderer should adjust effective rectangle of the cell to show the icon.
 * Instances of this class should render only the icon for a node, and not the actual node value. Node value will be painted using
 * default renderer of the table.
 *
 * @see TreeTableCellRenderer
 */
public interface TreeNodeRenderer {
    /**
     * Returns the component used to paint given cell.
     *
     * @param treeTable                         tree table in which node is to be rendered
     * @param isSelected                        <code>true</code> if node is currently selected
     * @param hasFocus                          <code>true</code> if node has focus
     * @param row                               row of the node
     * @param column                            column of the node
     * @return                                  component used to paint the node of the tree
     */
    Component getTableCellRendererComponent(JTreeTable treeTable,boolean isSelected,boolean hasFocus,int row,int column);
    /**
     * Called by tree table to adjust the effective rectangle of a cell in given row. If node renderer displays an icon
     * in front of a node, then this method should adjust the rectangle not to cover the icon.
     *
     * @param treeTable                         tree table in which node is to be rendered
     * @param row                               row of the node
     * @param column                            column of the node
     * @param rectangle                         rectangle to be adjusted
     */
    void adjustEffectiveRect(JTreeTable treeTable,int row,int column,Rectangle rectangle);
}
