package de.fzi.wim.guibase.treetable;

import javax.swing.UIManager;

/**
 * Default implementation of {@link TreePathMeasurer} interface.
 */
public class DefaultTreePathMeasurer implements TreePathMeasurer {
    /** Indentation of each level from the left. */
    protected int m_leftChildIndent;
    /** Indentation of each level from the right. */
    protected int m_rightChildIndent;
    /** Total indentation of each child (= <code>m_leftChildIndent</code> + <code>m_rightChildIndent</code>. */
    protected int m_totalChildIndent;

    /**
     * Creates an instance of this class and initializes it with L&F defaults.
     */
    public DefaultTreePathMeasurer() {
        setLeftChildIndent(((Integer)UIManager.get("Tree.leftChildIndent")).intValue());
        setRightChildIndent(((Integer)UIManager.get("Tree.rightChildIndent")).intValue());
    }
    /**
     * Sets the indentation of each level from the left.
     *
     * @param newAmount                         indentation of each level from the left
     */
    public void setLeftChildIndent(int newAmount) {
        m_leftChildIndent=newAmount;
        m_totalChildIndent=m_leftChildIndent+m_rightChildIndent;
    }
    /**
     * Returns the indentation of each level from the left.
     *
     * @return                                  indentation of each level from the left
     */
    public int getLeftChildIndent() {
        return m_leftChildIndent;
    }
    /**
     * Sets the indentation of each level from the right.
     *
     * @param newAmount                         indentation of each level from the right
     */
    public void setRightChildIndent(int newAmount) {
        m_rightChildIndent=newAmount;
        m_totalChildIndent=m_leftChildIndent+m_rightChildIndent;
    }
    /**
     * Returns the indentation of each level from the right.
     *
     * @return                                  indentation of each level from the right
     */
    public int getRightChildIndent() {
        return m_rightChildIndent;
    }
    /**
     * Called to measure a path in the tree table.
     *
     * @param treeTable                     tree table where path is measured
     * @param node                          node being measured
     * @param row                           row in which path is measured
     * @param depth                         depth of the path being measured
     * @param size                          object to be filled with dimension information
     */
    public void measureTreePath(JTreeTable treeTable,Object node,int row,int depth,TreePathMeasurer.TreePathDimensions size) {
        size.m_height=20;
        size.m_indentation=m_totalChildIndent*depth;
    }
}

