package de.fzi.wim.guibase.selectionsource;

import java.util.EventListener;

/**
 * A listener for the selection source manager.
 */
public interface SelectionSourceManagerListener extends EventListener {
    /**
     * Called when the active selection source changed.
     *
     * @param selectionSourceManager            the manager of the selection source
     * @param activeSelectionSource             the selection source that is now active
     */
    void activeSelectionSourceChanged(SelectionSourceManager selectionSourceManager,SelectionSource activeSelectionSource);
    /**
     * Called when the selection in a selection source changed.
     *
     * @param selectionSourceManager            the manager of the selection source
     * @param selectionSource                   the selection source that is which the selection changed
     * @param isActive                          <code>true</code> if the selection source is currently active
     */
    void selectionChanged(SelectionSourceManager selectionSourceManager,SelectionSource selectionSource,boolean isActive);
}
