package de.fzi.wim.guibase.selectionsource;

import java.util.Collection;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;

import de.fzi.wim.guibase.dnd.*;

/**
 * A drag source for a selection source.
 */
public class SelectionSourceDragSource implements DragGestureListener,DragSourceListener {
    /** The selection source for this drag source. */
    protected SelectionSource m_selectionSource;
    /** Drag source for the table. */
    protected DragSource m_dragSource;

    /**
     * Attachs this manputlator to tree table.
     *
     * @param selectionSource                   the selection source
     */
    public SelectionSourceDragSource(SelectionSource selectionSource) {
        m_selectionSource=selectionSource;
        m_dragSource=new DragSource();
        m_dragSource.createDefaultDragGestureRecognizer(m_selectionSource.getComponent(),DnDConstants.ACTION_MOVE,this);
    }
    /**
     * Listener of drag gestures that initiates a DND operation.
     *
     * @param event                             event object
     */
    public void dragGestureRecognized(DragGestureEvent event) {
        try {
            Collection selection=m_selectionSource.getSelection();
            event.startDrag(DragSource.DefaultMoveDrop,new CollectionSelection(selection),this);
        }
        catch (InvalidDnDOperationException ignored) {
        }
    }
    /**
     * This method is invoked to signify that the Drag and Drop operation is complete.
     */
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }
    /**
     * Called as the hotspot enters a platform dependent drop site.
     */
    public void dragEnter(DragSourceDragEvent dsde) {
    }
    /**
     * Called as the hotspot exits a platform dependent drop site.
     */
    public void dragExit(DragSourceEvent dse) {
    }
    /**
     * Called as the hotspot moves over a platform dependent drop site.
     */
    public void dragOver(DragSourceDragEvent dsde) {
    }
    /**
     * Called when the user has modified the drop gesture.
     */
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    /**
     * Table UI that doesn't allow dragging.
     */
    public static class NoDragSelectionTableUI extends BasicTableUI {
        protected MouseInputListener createMouseInputListener() {
            return new MouseInputHandler() {
                public void mouseDragged(MouseEvent e) {
                }
            };
        }
    }
}
