package de.fzi.wim.guibase.selectionsource;

import java.util.Collection;
import javax.swing.JComponent;

/**
 * Represents an object capable of changing the selection.
 */
public interface SelectionSource {
    /**
     * Returns the current selection.
     *
     * @return                                  the current selection
     */
    Collection getSelection();
    /**
     * Notifies the source that his selection is currently the primary selection.
     */
    void notifySelectionPrimary();
    /**
     * Notifies the source that his selection is currently the secondary selection.
     */
    void notifySelectionSecondary();
    /**
     * The component of the selection source.
     *
     * @return                                  the component of the selection source
     */
    JComponent getComponent();
}
