package de.fzi.wim.guibase.selectionsource;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;

import de.fzi.wim.guibase.treetable.*;

/**
 * A utility implementation of the tree table selection source.
 */
public abstract class AbstractJTreeTableSelectionSource extends JTreeTable implements SelectionSource,FocusListener {
    /** The selection source manager. */
    protected SelectionSourceManager m_selectionSourceManager;

    /**
     * Creates a helper and attaches it to a table.
     *
     * @param selectionSourceManager                the manager for the selection source
     * @param treeTableModel                        the tree table model
     */
    public AbstractJTreeTableSelectionSource(SelectionSourceManager selectionSourceManager,TreeTableModel treeTableModel) {
        super(treeTableModel);
        m_selectionSourceManager=selectionSourceManager;
        addFocusListener(this);
    }
    /**
     * Called when the table gains the focus.
     *
     * @param e                                     the event
     */
    public void focusGained(FocusEvent e) {
        m_selectionSourceManager.setActiveSelectionSource(this);
    }
    /**
     * Called when the table looses the focus.
     *
     * @param e                                     the event
     */
    public void focusLost(FocusEvent e) {
    }
    /**
     * Called then the selection in the table changes.
     *
     * @param e                                     the event
     */
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (m_selectionSourceManager!=null)
            m_selectionSourceManager.notifySelectionChanged(this);
    }
    /**
     * Notifies the source that his selection is currently the primary selection.
     */
    public void notifySelectionPrimary() {
        setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        setSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
    }
    /**
     * Notifies the source that his selection is currently the secondary selection.
     */
    public void notifySelectionSecondary() {
        setSelectionBackground(Color.lightGray);
        setSelectionForeground(Color.white);
    }
    /**
     * The component of the selection source.
     *
     * @return                                  the component of the selection source
     */
    public JComponent getComponent() {
        return this;
    }
}
