package de.fzi.wim.guibase.selectionsource;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTree;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

/**
 * A utility implementation of the tree selection source.
 */
public abstract class AbstractJTreeSelectionSource extends JTree implements SelectionSource,TreeSelectionListener,FocusListener{
    /** The selection source manager. */
    protected SelectionSourceManager m_selectionSourceManager;

    /**
     * Creates a helper and attaches it to a tree.
     *
     * @param selectionSourceManager                the manager for the selection source
     * @param treeModel                             the tree model
     */
    public AbstractJTreeSelectionSource(SelectionSourceManager selectionSourceManager,TreeModel treeModel) {
        super(treeModel);
        m_selectionSourceManager=selectionSourceManager;
        addFocusListener(this);
        addTreeSelectionListener(this);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                notifySelectionSecondary();
            }
        });
    }
    /**
     * Called when the tree gains the focus.
     *
     * @param e                                     the event
     */
    public void focusGained(FocusEvent e) {
        m_selectionSourceManager.setActiveSelectionSource(this);
    }
    /**
     * Called when the tree looses the focus.
     *
     * @param e                                     the event
     */
    public void focusLost(FocusEvent e) {
    }
    /**
     * Called then the selection in the tree changes.
     *
     * @param e                                     the event
     */
    public void valueChanged(TreeSelectionEvent e) {
        m_selectionSourceManager.notifySelectionChanged(this);
    }
    /**
     * Notifies the source that his selection is currently the primary selection.
     */
    public void notifySelectionPrimary() {
        DefaultTreeCellRenderer cellRenderer=(DefaultTreeCellRenderer)getCellRenderer();
        cellRenderer.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        cellRenderer.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        repaint();
    }
    /**
     * Notifies the source that his selection is currently the secondary selection.
     */
    public void notifySelectionSecondary() {
        DefaultTreeCellRenderer cellRenderer=(DefaultTreeCellRenderer)getCellRenderer();
        cellRenderer.setBackgroundSelectionColor(Color.lightGray);
        cellRenderer.setTextSelectionColor(Color.white);
        repaint();
    }
    /**
     * The component of the selection source.
     *
     * @return                                  the component of the selection source
     */
    public JComponent getComponent() {
        return this;
    }
}
