package de.fzi.wim.guibase.menus;

import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.TreePath;

/**
 * Popup menu manipulator for trees.
 */
public class JTreePopupMenuManipulator extends MouseAdapter {
    /** The popup menu. */
    protected JPopupMenu m_popupMenu;

    /**
     * Attachs this manputlator to the tree.
     *
     * @param tree                              the tree to which the manipulator is attached
     * @param popupMenu                         the popup menu
     */
    public JTreePopupMenuManipulator(JTree tree,JPopupMenu popupMenu) {
        m_popupMenu=popupMenu;
        tree.addMouseListener(this);
    }
    /**
     * Called when mouse is pressed.
     *
     * @param event                             event object
     */
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger())
            showPopup(event);
    }
    /**
     * Called when mouse is released.
     *
     * @param event                             event object
     */
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger())
            showPopup(event);
    }
    /**
     * Displays a popup at given location.
     *
     * @param event                             event object
     */
    protected void showPopup(MouseEvent event) {
        final JTree tree=(JTree)event.getComponent();
        final int x=event.getX();
        final int y=event.getY();
        if (!tree.hasFocus())
            tree.requestFocus();
        int row=tree.getRowForLocation(x,y);
        if (row!=-1) {
            TreePath path=tree.getPathForRow(row);
            boolean toggle=(event.getModifiers() & MouseEvent.CTRL_MASK)!=0;
            boolean extend=(event.getModifiers() & MouseEvent.SHIFT_MASK)!=0;
            if (toggle) {
                if (tree.isPathSelected(path))
                    tree.removeSelectionPath(path);
                else
                    tree.addSelectionPath(path);
                tree.setAnchorSelectionPath(path);
                tree.setLeadSelectionPath(path);
            }
            else if (extend) {
                TreePath anchor=tree.getAnchorSelectionPath();
                int anchorRow=(anchor==null) ? -1 : tree.getRowForPath(anchor);
                if (anchorRow==-1 || tree.getSelectionModel().getSelectionMode()==TreeSelectionModel.SINGLE_TREE_SELECTION)
                    tree.setSelectionPath(path);
                else {
                    if (row<anchorRow)
                        tree.setSelectionInterval(row,anchorRow);
                    else
                        tree.setSelectionInterval(anchorRow,row);
                    tree.setAnchorSelectionPath(anchor);
                    tree.setLeadSelectionPath(path);
                }
            }
            else
                tree.setSelectionPath(path);
        }
        m_popupMenu.revalidate();
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                m_popupMenu.show(tree,x,y);
            }
        });
    }
}
