package de.fzi.wim.guibase.menus;

import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

/**
 * Popup menu manipulator for tables.
 */
public class JTablePopupMenuManipulator extends MouseAdapter {
    /** The popup menu. */
    protected JPopupMenu m_popupMenu;

    /**
     * Attachs this manputlator to the table.
     *
     * @param table                             the table to which the manipulator is attached
     * @param popupMenu                         the popup menu
     */
    public JTablePopupMenuManipulator(JTable table,JPopupMenu popupMenu) {
        m_popupMenu=popupMenu;
        table.addMouseListener(this);
    }
    /**
     * Called when mouse is pressed.
     *
     * @param event                             event object
     */
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger())
            showPopup(event);
    }
    /**
     * Called when mouse is released.
     *
     * @param event                             event object
     */
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger())
            showPopup(event);
    }
    /**
     * Displays a popup at given location.
     *
     * @param event                             event object
     */
    protected void showPopup(MouseEvent event) {
        final JTable table=(JTable)event.getComponent();
        final int x=event.getX();
        final int y=event.getY();
        if (!table.hasFocus())
            table.requestFocus();
        int row=table.rowAtPoint(event.getPoint());
        if (row!=-1)
            table.changeSelection(row,0,(event.getModifiers() & MouseEvent.CTRL_MASK)!=0,(event.getModifiers() & MouseEvent.SHIFT_MASK)!=0);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                m_popupMenu.show(table,x,y);
            }
        });
    }
}
