package de.fzi.wim.guibase.lazytreemodel;

import javax.swing.tree.TreeNode;

/**
 * Objects implementing this interface can be used in subclasses of {@link LazyTreeModel} and can have their
 * children loaded lazily. Tree node must not worry about threading - all calls to it will be done on Swing main thread.
 *
 * @see LazyTreeModel
 */
public interface LazyTreeNode extends TreeNode {
	/** Constant identifying that node has been fully loaded. */
	final int LOADED=0;
	/** Constant identifying that node is currently being loaded. */
	final int LOADING=1;
	/** Constant identifying that node hasn't been loaded yet. */
	final int NOT_LOADED=2;

	/**
	 * Returns the state of the node (must be one of <code>LOADED</code>, <code>LOADING</code> or <code>NOT_LOADED</code>).
	 *
	 * @return                      current state of the node
	 */
	int getNodeState();
	/**
	 * Marks the node as being loaded. This method should transition the node into <code>LOADING</code> state.
	 */
	void setNodeLoading();
    /**
     * Unloads all children of a node.
     */
    void unloadChildren();
	/**
	 * Notifies the node that its children have been loaded and supplies it the array of loaded children. This method should
	 * transtion the node into <code>LOADED</code> state. It is possible that some child nodes aren't <code>LazyTreeNode</code>s -
	 * in that case {@link LazyTreeModel} will assume that these nodes have been fully loaded.
	 *
	 * @param children              array of children of this node
	 */
	void setChildrenLoaded(TreeNode[] children);
    /**
     * Retruns the array of children of this node. If node is not loaded, <code>null</code> is returned.
     *
     * @return                      array of children of this node
     */
    TreeNode[] getChildren();
}
