package de.fzi.wim.guibase.lazytreemodel;

import javax.swing.tree.TreeNode;

/**
 * Objects implementing this interface will be used by {@link LazyTreeModel} instances to load children of some node on demand.
 * Loader can load nodes synchronously, or can choose to process the request asynchronously. In that case he should indicate
 * in its return value that loading of the node was deferred. When children of some node have actually been loaded, this class
 * should invoke {@link LazyTreeModel#notifyChildrenLoaded} method. This call must always be done on the main thread.
 *
 * @see LazyTreeModel
 */
public interface LazyNodeLoader {
    /** Constant indicating that loading of children has been deferred. */
    final TreeNode[] LOAD_DEFERRED=new TreeNode[0];
    /** Constant indicating that loading of children has been canceled. */
    final TreeNode[] LOAD_CANCELED=new TreeNode[0];
    /**
     * Called by the {@link LazyTreeModel} to load children of some node. This method can process the request synchornously,
     * or can return {@link #LOAD_DEFERRED} constant indicating that nodes will be loaded later. When nodes are loaded,
     * this class must invoke {@link LazyTreeModel#notifyChildrenLoaded} method (on the main thread).
     *
     * @param model                 model that requested the load
     * @param node                  node whose children need to be loaded
     * @return                      array of loaded children (or {@link #LOAD_DEFERRED} indicating that load will be done later)
     */
	TreeNode[] loadNodeChildren(LazyTreeModel model,LazyTreeNode node);
}
