package de.fzi.wim.guibase.lazytreemodel;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.TreeNode;

/**
 * Utility class that displays a message when data is loading.
 */
public class DefaultNoChildrenNode implements TreeNode,Enumeration {
    /** Message that is displayed when node is loading. */
    protected String m_message;
    /** Parent of this node. */
    protected TreeNode m_parent;

    /**
     * Creates a dummy node with some message.
     *
     * @param message                   message shown by this node
     * @param parent                    parent of this node
     */
    public DefaultNoChildrenNode(String message,TreeNode parent) {
        m_message=message;
        m_parent=parent;
    }
    /**
     * Returns an empty enumeration.
     *
     * @return                          empty enumeration
     */
    public Enumeration children() {
        return this;
    }
    /**
     * Always returns <code>false</code> since this node can never have children.
     *
     * @return                          always <code>false</code>
     */
    public boolean getAllowsChildren() {
        return false;
    }
    /**
     * Always returns <code>null</code> since this node can never have children.
     *
     * @return                          always <code>null</code>
     */
    public TreeNode getChildAt(int childIndex) {
        return null;
    }
    /**
     * Returns 0, since this node can never have any children.
     *
     * @return                          always zero
     */
    public int getChildCount() {
        return 0;
    }
    /**
     * Returns always -1 since this node can neven have any children.
     *
     * @param node                      node whose index is sought for
     * @return                          always -1
     */
    public int getIndex(TreeNode node) {
        return -1;
    }
    /**
     * Returns always <code>null</code> since this node can be parented anywhere in the tree.
     *
     * @return                          always <code>null</code>
     */
    public TreeNode getParent() {
        return m_parent;
    }
    /**
     * Returns always <code>true</code> since this node is always leaf node.
     *
     * @return                          always <code>true</code>
     */
    public boolean isLeaf() {
        return true;
    }
    /**
     * Converts this node to string.
     *
     * @return                          message of this node
     */
    public String toString() {
        return m_message;
    }
    /**
     * Returns always <code>false</code> since this node never has any children.
     *
     * @return                          always <code>false</code>
     */
    public boolean hasMoreElements() {
        return false;
    }
    /**
     * Always throws an exception.
     */
    public Object nextElement() {
        throw new NoSuchElementException();
    }
}

