package de.fzi.wim.guibase.graphview.view;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * The painter for the node.
 */
public interface NodePainter {
    /**
     * Paints the supplied node.
     *
     * @param graphPane             the graph pane
     * @param g                     the graphics
     * @param node                  the node to paint
     */
    void paintNode(JGraphPane graphPane,Graphics2D g,Node node);
    /**
     * Checks whether given point is inside the node.
     *
     * @param graphPane             the graph pane
     * @param node                  the node
     * @param point                 the point
     * @return                      <code>true</code> if the point is in the node
     */
    boolean isInNode(JGraphPane graphPane,Node node,Point point);
    /**
     * Returns the outer rectangle of the node on screen.
     *
     * @param graphPane             the graph pane
     * @param node                  the node
     * @param nodeScreenRectangle   the rectangle receiving the node's coordinates
     */
    void getNodeScreenBounds(JGraphPane graphPane,Node node,Rectangle nodeScreenRectangle);
    /**
     * Retruns the tool-tip for given point.
     *
     * @param graphPane             the graph pane
     * @param node                  the node
     * @param point                 the point
     * @return                      the tool-tip at given point (or <code>null</code>)
     */
    String getToolTipText(JGraphPane graphPane,Node node,Point point);
}
