package de.fzi.wim.guibase.graphview.view;

import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.KeyListener;
import java.awt.event.FocusListener;

/**
 * A manipulator gets to process UI events in the graph pane.
 */
public interface Manipulator extends MouseListener,MouseMotionListener,KeyListener,FocusListener {
    /**
     * Sets the graph pane to the manipulator.
     *
     * @param graphPane                     the graph pane
     */
    void setGraphPane(JGraphPane graphPane);
    /**
     * Returns the manipulator name. This is used to better search manipulators.
     *
     * @return                              the name of the manipulator
     */
    String getName();
    /**
     * Gives the manipulator an opportunity to update the screen.
     *
     * @param g                             the graphics where drawing should be performed
     */
    void paint(Graphics2D g);
    /**
     * Notifies the manipulator that the graph pane has been scrolled.
     */
    void notifyGraphPaneScrolled();
}
