package de.fzi.wim.guibase.graphview.view;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * The painter for the edge.
 */
public interface EdgePainter {
    /**
     * Paints the supplied edge.
     *
     * @param graphPane             the graph pane
     * @param g                     the graphics
     * @param edge                  the edge to paint
     */
    void paintEdge(JGraphPane graphPane,Graphics2D g,Edge edge);
    /**
     * Returns the distance of the point to the edge.
     *
     * @param graphPane             the graph pane
     * @param edge                  the edge
     * @param point                 the point
     * @return                      the distance of the point from the edge
     */
    double screenDistanceFromEdge(JGraphPane graphPane,Edge edge,Point point);
    /**
     * Returns the outer rectangle of the edge on screen.
     *
     * @param graphPane             the graph pane
     * @param edge                  the edge
     * @param edgeScreenRectangle   the rectangle receiving the edge's coordinates
     */
    void getEdgeScreenBounds(JGraphPane graphPane,Edge edge,Rectangle edgeScreenRectangle);
}
