package de.fzi.wim.guibase.graphview.view;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.KeyEvent;
import java.awt.event.FocusEvent;

/**
 * A utility abstract class providing default implementation of listener methods.
 */
public abstract class AbstractManipulator implements Manipulator {
    /** The graph pane. */
    protected JGraphPane m_graphPane;
    /** The screen point of the last mouse event. */
    protected Point m_lastMouseEventScreenPoint;

    public void setGraphPane(JGraphPane graphPane) {
        m_graphPane=graphPane;
    }
    public void paint(Graphics2D g) {
    }
    public void mouseClicked(MouseEvent e) {
    }
    public void mousePressed(MouseEvent e) {
    }
    public void mouseReleased(MouseEvent e) {
    }
    public void mouseEntered(MouseEvent e) {
    }
    public void mouseExited(MouseEvent e) {
    }
    public void mouseDragged(MouseEvent e) {
    }
    public void mouseMoved(MouseEvent e) {
    }
    public void keyTyped(KeyEvent e) {
    }
    public void keyPressed(KeyEvent e) {
    }
    public void keyReleased(KeyEvent e) {
    }
    public void focusGained(FocusEvent e) {
    }
    public void focusLost(FocusEvent e) {
    }
    public void notifyGraphPaneScrolled() {
    }
    protected void updateLastMouseEventScreenPoint(MouseEvent e) {
        Point point=e.getPoint();
        m_lastMouseEventScreenPoint=m_graphPane.getLocationOnScreen();
        m_lastMouseEventScreenPoint.x+=point.x;
        m_lastMouseEventScreenPoint.y+=point.y;
    }
    protected Point getLastMouseEventPoint() {
        Point point=m_graphPane.getLocationOnScreen();
        point.setLocation(m_lastMouseEventScreenPoint.x-point.x,m_lastMouseEventScreenPoint.y-point.y);
        return point;
    }
    protected void autoscroll(MouseEvent e) {
        if (!m_graphPane.getVisibleRect().contains(e.getX(),e.getY()))
            m_graphPane.scrollRectToVisible(new Rectangle(e.getX(),e.getY(),1,1));
    }
}
