package de.fzi.wim.guibase.graphview.lens;

import java.util.List;
import java.util.ArrayList;
import java.awt.geom.Point2D;

/**
 * A collection of lenses, where each lens is a function that warps 2D space.
 * This class has been inspired by the <a href="http://www.touchgraph.com/">TouchGraph</a> library.
 */
public class LensSet extends AbstractLens implements LensListener {
    /** The list of lenses. */
    protected List m_lenses;

    /**
     * Creates the lens set.
     */
    public LensSet() {
        m_lenses=new ArrayList();
    }
    /**
     * Adds the lens to the set.
     *
     * @param lens                  the lens added
     */
    public void addLens(Lens lens) {
        m_lenses.add(lens);
        lens.addLensListener(this);
    }
    /**
     * Applies the lenses.
     *
     * @param point                 the point
     */
    public void applyLens(Point2D point) {
        for (int i=0;i<m_lenses.size();i++) {
            Lens lens=(Lens)m_lenses.get(i);
            lens.applyLens(point);
        }
    }
    /**
     * Undoes the lenses.
     *
     * @param point                 the point
     */
    public void undoLens(Point2D point) {
        for (int i=m_lenses.size()-1;i>=0;i--) {
            Lens lens=(Lens)m_lenses.get(i);
            lens.undoLens(point);
        }
    }
    /**
     * Called whenever the lens changes its parameters.
     *
     * @param lens                      the lens that changed its parameters
     */
    public void lensUpdated(Lens lens) {
        fireLensUpdated();
    }
}
