package de.fzi.wim.guibase.graphview.lens;

import java.util.EventListener;
import javax.swing.event.EventListenerList;

/**
 * A utility base class for all lenses.
 */
public abstract class AbstractLens implements Lens {
    /** The list of listeners. */
    protected EventListenerList m_listeners;

    /**
     * Creates an instance of this class.
     */
    public AbstractLens() {
        m_listeners=new EventListenerList();
    }
    /**
     * Adds a listener to the lens.
     *
     * @param listener          the listener to add
     */
    public void addLensListener(LensListener listener) {
        m_listeners.add(LensListener.class,listener);
    }
    /**
     * Removes a listener from the lens.
     *
     * @param listener          the listener to remove
     */
    public void removeLensListener(LensListener listener) {
        m_listeners.remove(LensListener.class,listener);
    }
    /**
     * Fires the notification that this lens was updated.
     */
    protected void fireLensUpdated() {
        EventListener[] listeners=m_listeners.getListeners(LensListener.class);
        for (int i=0;i<listeners.length;i++)
            ((LensListener)listeners[i]).lensUpdated(this);
    }
}