package de.fzi.wim.guibase.graphview.inplaceedit;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.view.*;


/**
 * Provides in-place editing of nodes using a text component.
 */
public class TextFieldInPlaceNodeEditor extends InPlaceNodeEditor implements FocusListener,ActionListener,KeyListener {

    public TextFieldInPlaceNodeEditor(JGraphPane graphPane,Node node,NodeEditingController nodeEditingController) {
        super(graphPane,node,nodeEditingController);
    }
    /**
     * Creates the editor component.
     *
     * @return                          the editor component
     */
    protected JComponent createEditorComponent() {
        JTextField textField=new JTextField();
        textField.addFocusListener(this);
        textField.addActionListener(this);
        textField.addKeyListener(this);
        return textField;
    }
    /**
     * Sets the value into the component.
     *
     * @param component                 the editor component
     * @param value                     the value
     */
    protected void setEditorComponentValue(JComponent component,Object value) {
        JTextField textField=(JTextField)component;
        if (value==null)
            textField.setText("");
        else
            textField.setText(value.toString());
    }
    /**
     * Notifies the component that editing is starting..
     *
     * @param component                             the editor component
     */
    protected void editingStarting(JComponent component) {
        JTextField textField=(JTextField)component;
        textField.selectAll();
        textField.requestFocus();
    }
    /**
     * Returns the current value of the component.
     *
     * @param component                 the editor component
     * @return                          the value
     */
    protected Object getEditorComponentValue(JComponent component) {
        return ((JTextField)component).getText();
    }
    /**
     * Updates the position of the node.
     */
    protected void updatePosition() {
        Rectangle nodeBounds=new Rectangle();
        m_graphPane.getNodeScreenBounds(m_node,nodeBounds);
        m_component.setLocation(nodeBounds.x-4,nodeBounds.y-4);
        m_component.setSize(nodeBounds.width+8,nodeBounds.height+8);
    }
    /**
     * Called when the focus is gained.
     *
     * @param e                         the event
     */
    public void focusGained(FocusEvent e) {
    }
    /**
     * Called when the focus is lost.
     *
     * @param e                         the event
     */
    public void focusLost(FocusEvent e) {
        stopOrAbortEditing();
    }
    /**
     * Called when an action occurs in the text field.
     *
     * @param e                         the event
     */
    public void actionPerformed(ActionEvent e) {
        stopOrAbortEditing();
    }
    /**
     * Called when the key has been typed.
     *
     * @param e                         the event
     */
    public void keyTyped(KeyEvent e) {
    }
    /**
     * Called when the key has been pressed.
     *
     * @param e                         the event
     */
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode()==KeyEvent.VK_ESCAPE)
            abortEditing();
    }
    /**
     * Called when the key has been released.
     *
     * @param e                         the event
     */
    public void keyReleased(KeyEvent e) {
    }
}
