package de.fzi.wim.guibase.graphview.inplaceedit ;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * Receives information about the node editing progress.
 */
public interface NodeEditingController {
    /**
     * Called before editing starts.
     *
     * @param node                          the node for which the editing was started
     * @return                              the object representing the initial value
     */
    Object editingStarted(Node node);
    /**
     * Called when editing finishes.
     *
     * @param node                          the node for which the editing was finished
     * @param value                         the new value
     * @return                              <code>true</code> if editing should stop
     */
    boolean editingFinished(Node node,Object value);
    /**
     * Called when editing is aborted.
     *
     * @param node                          the node for which the editing was aborted
     */
    void editingAborted(Node node);
}
