package de.fzi.wim.guibase.graphview.graph;

import java.util.EventListener;
import java.util.Collection;

/**
 * The listener for graph events.
 */
public interface GraphListener extends EventListener {
    /**
     * Called when graph layout is updated.
     *
     * @param graph                     the graph
     */
    void graphLayoutUpdated(Graph graph);
    /**
     * Called when graph has changed, but no nodes have changed their position.
     *
     * @param graph                     the graph
     */
    void graphUpdated(Graph graph);
    /**
     * Called when graph contents is radically changed.
     *
     * @param graph                     the graph
     */
    void graphContentsChanged(Graph graph);
    /**
     * Called when elements are added to the graph.
     *
     * @param graph                     the graph
     * @param nodes                     the nodes added (may be <code>null</code>)
     * @param edges                     the edges added (may be <code>null</code>)
     */
    void elementsAdded(Graph graph,Collection nodes,Collection edges);
    /**
     * Called when elements are removed from the graph.
     *
     * @param graph                     the graph
     * @param nodes                     the nodes added (may be <code>null</code>)
     * @param edges                     the edges added (may be <code>null</code>)
     */
    void elementsRemoved(Graph graph,Collection nodes,Collection edges);
}
