package de.fzi.wim.guibase.graphview.graph;

import  java.util.Collection;
import  java.util.Iterator;
import  java.util.List;
import  java.util.LinkedList;

/**
 * A default implementation of a mutable graph.
 */
public class DefaultGraph extends AbstractGraph {
    /** Nodes of the graph. */
    protected List m_nodes;
    /** Edges of the graph. */
    protected List m_edges;

    /**
     * Creates a new graph.
     */
    public DefaultGraph() {
        m_nodes=new LinkedList();
        m_edges=new LinkedList();
    }
    /**
     * Returns a collection of the nodes in the graph.
     *
     * @return                      a collection of the nodes in the graph
     */
    public List getNodes() {
        return m_nodes;
    }
    /**
     * Returns a collection of the edges in the graph.
     *
     * @return                      the collection of the edges in the graph
     */
    public List getEdges() {
        return m_edges;
    }
    /**
     * Adds elements to the graph.
     *
     * @param nodes                 the nodes added to the graph (may be <code>null</code>)
     * @param edges                 the edges added to the graph (may be <code>null</code>)
     */
    public synchronized void addElements(Collection nodes,Collection edges) {
        if (nodes!=null) {
            Iterator iterator=nodes.iterator();
            while (iterator.hasNext()) {
                DefaultNode node=(DefaultNode)iterator.next();
                if (!m_nodes.contains(node))
                    m_nodes.add(node);
            }
        }
        if (edges!=null) {
            Iterator iterator=edges.iterator();
            while (iterator.hasNext()) {
                DefaultEdge edge=(DefaultEdge)iterator.next();
                if (!m_edges.contains(edge)) {
                    m_edges.add(edge);
                    ((DefaultNode)edge.getFrom()).notifyEdgeAdded(edge);
                    ((DefaultNode)edge.getTo()).notifyEdgeAdded(edge);
                }
            }
        }
        fireElementsAdded(nodes,edges);
    }
    /**
     * Deletes elements from the graph.
     *
     * @param nodes                 the nodes to delete (may be <code>null</code>)
     * @param edges                 the edges to delete (may be <code>null</code>)
     */
    public synchronized void deleteElements(Collection nodes,Collection edges) {
        if (nodes!=null) {
            Iterator iterator=nodes.iterator();
            while (iterator.hasNext()) {
                DefaultNode node=(DefaultNode)iterator.next();
                m_nodes.remove(node);
            }
        }
        if (edges!=null) {
            Iterator iterator=edges.iterator();
            while (iterator.hasNext()) {
                DefaultEdge edge=(DefaultEdge)iterator.next();
                if (m_edges.remove(edge)) {
                    ((DefaultNode)edge.getFrom()).notifyEdgeRemoved(edge);
                    ((DefaultNode)edge.getTo()).notifyEdgeRemoved(edge);
                }
            }
        }
        fireElementsRemoved(nodes,edges);
    }
    /**
     * Clears the graph.
     */
    public synchronized void clear() {
        m_nodes.clear();
        m_edges.clear();
        fireGraphContentsChanged();
    }
}
